/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class HideUtilityClassConstructorCheck
extends AbstractCheck {
    public static final String MSG_KEY = "hide.utility.class";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST ast) {
        if (!HideUtilityClassConstructorCheck.isAbstract(ast)) {
            boolean isUtilClass;
            DetailAST objBlock = ast.findFirstToken(6);
            boolean hasStaticModifier = HideUtilityClassConstructorCheck.isStatic(ast);
            boolean hasMethodOrField = false;
            boolean hasNonStaticMethodOrField = false;
            boolean hasNonPrivateStaticMethodOrField = false;
            boolean hasDefaultCtor = true;
            boolean hasPublicCtor = false;
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                DetailAST modifiers;
                int type = child.getType();
                if (type == 9 || type == 10) {
                    hasMethodOrField = true;
                    modifiers = child.findFirstToken(5);
                    boolean isStatic = modifiers.branchContains(64);
                    boolean isPrivate = modifiers.branchContains(61);
                    if (!isStatic && !isPrivate) {
                        hasNonStaticMethodOrField = true;
                    }
                    if (isStatic && !isPrivate) {
                        hasNonPrivateStaticMethodOrField = true;
                    }
                }
                if (type != 8) continue;
                hasDefaultCtor = false;
                modifiers = child.findFirstToken(5);
                if (modifiers.branchContains(61) || modifiers.branchContains(63)) continue;
                hasPublicCtor = true;
            }
            boolean hasAccessibleCtor = hasDefaultCtor || hasPublicCtor;
            boolean extendsJlo = ast.findFirstToken(18) == null;
            boolean bl = isUtilClass = extendsJlo && hasMethodOrField && !hasNonStaticMethodOrField && hasNonPrivateStaticMethodOrField;
            if (isUtilClass && hasAccessibleCtor && !hasStaticModifier) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
            }
        }
    }

    private static boolean isAbstract(DetailAST ast) {
        DetailAST abstractAST = ast.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private static boolean isStatic(DetailAST ast) {
        DetailAST staticAST = ast.findFirstToken(5).findFirstToken(64);
        return staticAST != null;
    }
}

