/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public class RedundantReturnCheck
extends AbstractCheck {
    public static final String MSG_KEY = "redundant.return.check";
    private boolean allowReturnInEmptyMethodsAndConstructors;

    public void setAllowReturnInEmptyMethodsAndConstructors(boolean allowEmptyBlocks) {
        this.allowReturnInEmptyMethodsAndConstructors = allowEmptyBlocks;
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void visitToken(DetailAST ast) {
        DetailAST blockAst = ast.getLastChild();
        switch (ast.getType()) {
            case 8: {
                if (this.ignoreLonelyReturn(blockAst) || !RedundantReturnCheck.hasNonEmptyBody(ast)) break;
                List<DetailAST> redundantReturns = RedundantReturnCheck.getRedundantReturns(blockAst);
                this.log(redundantReturns);
                break;
            }
            case 9: {
                if (this.ignoreLonelyReturn(blockAst) || !RedundantReturnCheck.isVoidMethodWithNonEmptyBody(ast)) break;
                List<DetailAST> redundantReturns = RedundantReturnCheck.getRedundantReturns(blockAst);
                this.log(redundantReturns);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private boolean ignoreLonelyReturn(DetailAST objectBlockAst) {
        return this.allowReturnInEmptyMethodsAndConstructors && objectBlockAst.getFirstChild().getType() == 88;
    }

    private static boolean hasNonEmptyBody(DetailAST defAst) {
        return defAst.getLastChild().getChildCount() > 1;
    }

    private static boolean isVoidMethodWithNonEmptyBody(DetailAST methodDefAst) {
        return methodDefAst.getLastChild().getType() == 7 && methodDefAst.findFirstToken(13).findFirstToken(49) != null && RedundantReturnCheck.hasNonEmptyBody(methodDefAst);
    }

    private void log(List<DetailAST> redundantReturnsAst) {
        for (DetailAST redundantLiteralReturnAst : redundantReturnsAst) {
            this.log(redundantLiteralReturnAst.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static List<DetailAST> getRedundantReturns(DetailAST objectBlockAst) {
        ArrayList<DetailAST> redundantReturns = new ArrayList<DetailAST>();
        int placeForRedundantReturn = objectBlockAst.getLastChild().getPreviousSibling().getType();
        if (placeForRedundantReturn == 88) {
            DetailAST lastChildAst = objectBlockAst.getLastChild();
            DetailAST redundantReturnAst = lastChildAst.getPreviousSibling();
            redundantReturns.add(redundantReturnAst);
        } else if (placeForRedundantReturn == 95 && !RedundantReturnCheck.getRedundantReturnsInTryCatchBlock(objectBlockAst.findFirstToken(95)).isEmpty()) {
            List<DetailAST> redundantsAst = RedundantReturnCheck.getRedundantReturnsInTryCatchBlock(objectBlockAst.findFirstToken(95));
            redundantReturns.addAll(redundantsAst);
        }
        return redundantReturns;
    }

    private static List<DetailAST> getRedundantReturnsInTryCatchBlock(DetailAST tryAst) {
        DetailAST afterCatchBlockAst;
        ArrayList<DetailAST> redundantReturns = new ArrayList<DetailAST>();
        DetailAST tryBlockAst = null;
        tryBlockAst = tryAst.getFirstChild().getType() == 176 ? tryAst.getFirstChild().getNextSibling() : tryAst.getFirstChild();
        DetailAST redundantReturnAst = RedundantReturnCheck.getRedundantReturnInBlock(tryBlockAst.getLastChild().getPreviousSibling());
        if (redundantReturnAst != null) {
            redundantReturns.add(redundantReturnAst);
        }
        DetailAST blockAst = tryBlockAst;
        DetailAST catchBlockAst = RedundantReturnCheck.getNextCatchBlock(blockAst);
        while (catchBlockAst != null) {
            DetailAST lastStatementOfCatchBlockAst = catchBlockAst.getLastChild().getLastChild().getPreviousSibling();
            if (lastStatementOfCatchBlockAst != null && (redundantReturnAst = RedundantReturnCheck.getRedundantReturnInBlock(lastStatementOfCatchBlockAst)) != null) {
                redundantReturns.add(redundantReturnAst);
            }
            blockAst = blockAst.getNextSibling();
            catchBlockAst = RedundantReturnCheck.getNextCatchBlock(blockAst);
        }
        if (blockAst.getNextSibling() != null && (redundantReturnAst = RedundantReturnCheck.getRedundantReturnInBlock((afterCatchBlockAst = blockAst.getNextSibling().getLastChild().getLastChild()).getPreviousSibling())) != null) {
            redundantReturns.add(redundantReturnAst);
        }
        return redundantReturns;
    }

    private static DetailAST getNextCatchBlock(DetailAST blockAst) {
        DetailAST catchBlockAst = null;
        if (blockAst.getNextSibling() != null && blockAst.getNextSibling().getType() == 96) {
            catchBlockAst = blockAst.getNextSibling();
        }
        return catchBlockAst;
    }

    private static DetailAST getRedundantReturnInBlock(DetailAST statementAst) {
        DetailAST redundantReturnAst = null;
        if (statementAst != null) {
            DetailAST foundRedundantReturnAst;
            if (statementAst.getType() == 88) {
                redundantReturnAst = statementAst;
            } else if (statementAst.getFirstChild() != null && (foundRedundantReturnAst = RedundantReturnCheck.findRedundantReturnInCatch(statementAst)) != null) {
                redundantReturnAst = foundRedundantReturnAst;
            }
        }
        return redundantReturnAst;
    }

    private static DetailAST findRedundantReturnInCatch(DetailAST lastStatementInCatchBlockAst) {
        DetailAST currentNodeAst;
        DetailAST redundantReturnAst = null;
        DetailAST toVisitAst = currentNodeAst = lastStatementInCatchBlockAst;
        DetailAST returnAst = null;
        while (toVisitAst != null) {
            if ((toVisitAst = Utils.getNextSubTreeNode(toVisitAst, currentNodeAst)) == null || toVisitAst.getParent().getParent().getNextSibling() != null && toVisitAst.getParent().getParent().getNextSibling().getType() != 73 || toVisitAst.getType() != 88 || toVisitAst.getParent().getNextSibling() != null) continue;
            returnAst = toVisitAst;
            while (toVisitAst != null && toVisitAst.getParent() != currentNodeAst.getLastChild()) {
                toVisitAst = toVisitAst.getParent();
            }
            if (toVisitAst != null) {
                redundantReturnAst = returnAst;
            }
            toVisitAst = returnAst;
        }
        currentNodeAst = Utils.getNextSubTreeNode(currentNodeAst, lastStatementInCatchBlockAst);
        return redundantReturnAst;
    }
}

