/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NoNullForCollectionReturnCheck
extends AbstractCheck {
    public static final String MSG_KEY = "no.null.for.collections";
    private static final String DEFAULT_COLLECTIONS = "AbstractCollection AbstractList AbstractQueue AbstractSequentialList AbstractSet ArrayBlockingQueue ArrayDeque ArrayList AttributeList BeanContextServicesSupport BeanContextSupport ConcurrentLinkedDeque ConcurrentLinkedQueue ConcurrentSkipListSet CopyOnWriteArrayList CopyOnWriteArraySet DelayQueue EnumSet HashSet JobStateReasons LinkedBlockingDeque LinkedBlockingQueue LinkedHashSet LinkedList LinkedTransferQueue PriorityBlockingQueue PriorityQueue RoleList RoleUnresolvedList Stack SynchronousQueue TreeSet Vector Collection List Map Set";
    private Set<String> collectionList = new HashSet<String>();
    private boolean searchThroughMethodBody;
    private LinkedList<DetailAST> methodDefs = new LinkedList();

    public NoNullForCollectionReturnCheck() {
        this.setCollectionList(DEFAULT_COLLECTIONS);
    }

    public final void setCollectionList(String collectionList) {
        this.collectionList.clear();
        for (String currentCollection : collectionList.split("\\s+")) {
            this.collectionList.add(currentCollection);
        }
    }

    public void setSearchThroughMethodBody(boolean searchThroughMethodBody) {
        this.searchThroughMethodBody = searchThroughMethodBody;
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 88};
    }

    public void beginTree(DetailAST rootAST) {
        this.methodDefs.clear();
    }

    public void visitToken(DetailAST detailAST) {
        switch (detailAST.getType()) {
            case 9: {
                if (!this.isReturnCollection(detailAST)) break;
                this.methodDefs.push(detailAST);
                break;
            }
            case 88: {
                DetailAST currentMethodDef;
                if (this.methodDefs.isEmpty() || !this.methodDefs.contains(currentMethodDef = NoNullForCollectionReturnCheck.getMethodDef(detailAST)) || !NoNullForCollectionReturnCheck.hasNullLiteralInReturn(detailAST) && (!this.searchThroughMethodBody || !NoNullForCollectionReturnCheck.isReturnedValueBeNull(detailAST))) break;
                this.log(detailAST.getLineNo(), MSG_KEY, new Object[0]);
                break;
            }
            default: {
                Utils.reportInvalidToken(detailAST.getType());
            }
        }
    }

    private boolean isReturnCollection(DetailAST methodDef) {
        DetailAST methodType = methodDef.findFirstToken(13);
        return (methodType = methodType.getFirstChild()).getType() == 17 || this.collectionList.contains(methodType.getText());
    }

    private static boolean hasNullLiteralInReturn(DetailAST returnLit) {
        DetailAST returnExpression = returnLit.findFirstToken(28);
        boolean result = false;
        if (returnExpression != null) {
            DetailAST ternary = returnExpression.getFirstChild();
            if (109 == ternary.getType()) {
                returnExpression = ternary;
            }
            result = returnExpression.getChildCount(135) > 0;
        }
        return result;
    }

    private static boolean isReturnedValueBeNull(DetailAST returnLit) {
        DetailAST variable;
        boolean result = false;
        DetailAST returnedExpression = returnLit.getFirstChild();
        if (returnedExpression.getType() != 45 && (variable = returnedExpression.findFirstToken(58)) != null) {
            String variableName = variable.getText();
            DetailAST methodDef = NoNullForCollectionReturnCheck.getMethodDef(returnLit);
            LinkedList<DetailAST> subblocks = NoNullForCollectionReturnCheck.getAllSubblocks(methodDef);
            subblocks.addFirst(methodDef);
            result = NoNullForCollectionReturnCheck.hasNullInDefinition(subblocks, variableName);
            if (result) {
                for (DetailAST subblock : subblocks) {
                    List<DetailAST> expressions = NoNullForCollectionReturnCheck.getChildren(NoNullForCollectionReturnCheck.getBlockBody(subblock), 28);
                    for (DetailAST expression : expressions) {
                        DetailAST assign = expression.findFirstToken(80);
                        if (assign == null || !variableName.equals(assign.findFirstToken(58).getText()) || assign.branchContains(135)) continue;
                        result = false;
                        break;
                    }
                    if (result) continue;
                    break;
                }
            }
        }
        return result;
    }

    private static LinkedList<DetailAST> getAllSubblocks(DetailAST blockDef) {
        DetailAST blockBody = NoNullForCollectionReturnCheck.getBlockBody(blockDef);
        LinkedList<DetailAST> subblocks = new LinkedList<DetailAST>();
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 83));
        LinkedList<DetailAST> elseBlocks = new LinkedList<DetailAST>();
        for (DetailAST currentIf : subblocks) {
            if (currentIf.getChildCount(92) <= 0) continue;
            elseBlocks.add(currentIf.findFirstToken(92));
        }
        if (!elseBlocks.isEmpty()) {
            subblocks.addAll(elseBlocks);
        }
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 84));
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 85));
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 91));
        subblocks.addAll(NoNullForCollectionReturnCheck.getChildren(blockBody, 95));
        LinkedList<DetailAST> nestedSubblocks = new LinkedList<DetailAST>();
        for (DetailAST currentSubblock : subblocks) {
            if (!currentSubblock.branchContains(7)) continue;
            nestedSubblocks.addAll(NoNullForCollectionReturnCheck.getAllSubblocks(currentSubblock));
        }
        subblocks.addAll(nestedSubblocks);
        return subblocks;
    }

    private static boolean hasNullInDefinition(List<DetailAST> subBlocks, String variableName) {
        boolean result = false;
        for (DetailAST subblock : subBlocks) {
            List<DetailAST> variableDefs = NoNullForCollectionReturnCheck.getChildren(NoNullForCollectionReturnCheck.getBlockBody(subblock), 10);
            boolean isFinded = false;
            for (DetailAST currentDef : variableDefs) {
                DetailAST variable = currentDef.findFirstToken(58);
                if (!variableName.equals(variable.getText())) continue;
                DetailAST variableDef = currentDef;
                DetailAST variableValue = variableDef.findFirstToken(80);
                result = variableValue != null ? (variableValue = variableValue.findFirstToken(28)).getFirstChild().getType() == 135 : true;
                isFinded = true;
                break;
            }
            if (!isFinded) continue;
            break;
        }
        return result;
    }

    private static List<DetailAST> getChildren(DetailAST root, int type) {
        LinkedList<DetailAST> children = new LinkedList<DetailAST>();
        DetailAST currentChild = root.findFirstToken(type);
        if (currentChild != null) {
            children.add(currentChild);
        }
        while (children.size() < root.getChildCount(type)) {
            if ((currentChild = currentChild.getNextSibling()).getType() != type) continue;
            children.add(currentChild);
        }
        return children;
    }

    private static DetailAST getMethodDef(DetailAST returnLit) {
        DetailAST methodDef = returnLit;
        while (methodDef.getType() != 9) {
            methodDef = methodDef.getParent();
        }
        return methodDef;
    }

    private static DetailAST getBlockBody(DetailAST blockDef) {
        DetailAST blockBody = blockDef.findFirstToken(7);
        if (blockBody == null) {
            blockBody = blockDef;
        }
        return blockBody;
    }
}

