/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class LineLengthExtendedCheck
extends Check {
    public static final String MSG_KEY = "maxLineLen";
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private int max = 80;
    private Pattern ignorePattern;
    private String[] lines;
    private boolean ignoreField;
    private boolean ignoreMethod;
    private boolean ignoreConstructor;
    private boolean ignoreClass;

    public void setIgnoreField(boolean value) {
        this.ignoreField = value;
    }

    public void setIgnoreMethod(boolean value) {
        this.ignoreMethod = value;
    }

    public void setIgnoreConstructor(boolean value) {
        this.ignoreConstructor = value;
    }

    public void setIgnoreClass(boolean value) {
        this.ignoreClass = value;
    }

    public LineLengthExtendedCheck() {
        this.setIgnorePattern("^$");
    }

    public int[] getDefaultTokens() {
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        if (this.ignoreClass) {
            tokens.add(14);
        }
        if (this.ignoreConstructor) {
            tokens.add(8);
        }
        if (this.ignoreField) {
            tokens.add(10);
        }
        if (this.ignoreMethod) {
            tokens.add(9);
        }
        int[] returnTokens = new int[tokens.size()];
        for (int index = 0; index < tokens.size(); ++index) {
            returnTokens[index] = (Integer)tokens.get(index);
        }
        return returnTokens;
    }

    public void visitToken(DetailAST ast) {
        DetailAST endOfIgnoreLine = ast.findFirstToken(7);
        if (null != ast.getParent() && ast.getParent().getType() == 6 || ast.getType() == 14) {
            int mNumberOfLine = ast.getLineNo();
            if (null == endOfIgnoreLine) {
                this.lines[mNumberOfLine - 1] = null;
            } else {
                for (int mEndNumberOfLine = endOfIgnoreLine.getLineNo(); mEndNumberOfLine >= mNumberOfLine; --mEndNumberOfLine) {
                    this.lines[mEndNumberOfLine - 1] = null;
                }
            }
        }
    }

    public void beginTree(DetailAST rootAST) {
        this.lines = this.getLines();
    }

    public void finishTree(DetailAST rootAST) {
        for (int i = 0; i < this.lines.length; ++i) {
            String line;
            int realLength;
            if (null == this.lines[i] || (realLength = CommonUtils.lengthExpandedTabs((String)(line = this.lines[i]), (int)line.length(), (int)this.getTabWidth())) <= this.max || this.ignorePattern.matcher(line).find()) continue;
            this.log(i + 1, MSG_KEY, new Object[]{this.max, realLength});
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public void setIgnorePattern(String format) throws ConversionException {
        try {
            this.ignorePattern = Pattern.compile(format);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + format, (Throwable)e);
        }
    }
}

