/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class StaticMethodCandidateCheck
extends Check {
    public static final String MSG_KEY = "static.method.candidate";
    private static final String COMMA_SEPARATOR = ",";
    private static final String[] DEFAULT_SKIPPED_METHODS = new String[]{"writeObject", "readObject", "readObjectNoData", "readResolve", "writeReplace"};
    private static final int[] FRAME_TOKENS = new int[]{14, 9, 83, 91, 84, 85, 96, 95, 154, 155, 12, 11, 8, 15};
    private List<String> skippedMethods = Arrays.asList(DEFAULT_SKIPPED_METHODS);
    private Frame currentFrame;

    public void setSkippedMethods(String skippedMethods) {
        String[] splitSkippedMethods;
        ArrayList<String> customSkippedMethods = new ArrayList<String>();
        for (String skippedMethod : splitSkippedMethods = skippedMethods.split(COMMA_SEPARATOR)) {
            customSkippedMethods.add(skippedMethod.trim());
        }
        this.skippedMethods = customSkippedMethods;
    }

    public int[] getAcceptableTokens() {
        return new int[]{14, 9, 83, 91, 84, 85, 96, 95, 10, 21, 154, 155, 28, 12, 11, 136, 78, 8, 13, 164, 166, 15, 79};
    }

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    public void beginTree(DetailAST rootAST) {
        this.currentFrame = new Frame(null);
        Arrays.sort(FRAME_TOKENS);
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 10: 
            case 21: {
                this.currentFrame.addField(ast);
                break;
            }
            case 28: {
                this.currentFrame.addExpr(ast);
                break;
            }
            case 78: 
            case 79: {
                this.currentFrame.hasLiteralThisOrSuper = true;
                break;
            }
            case 13: 
            case 164: {
                Optional firstChild = Optional.fromNullable((Object)ast.getFirstChild());
                if (!firstChild.isPresent() || ((DetailAST)firstChild.get()).getType() != 58) break;
                this.currentFrame.addType(((DetailAST)firstChild.get()).getText());
                break;
            }
            case 166: {
                this.currentFrame.addTypeVariable(ast.getFirstChild().getText());
                break;
            }
            case 9: {
                Frame frame = this.createMethodFrame(this.currentFrame, ast);
                this.currentFrame.addMethod(ast);
                this.currentFrame.addChild(frame);
                this.currentFrame = frame;
                break;
            }
            case 136: {
                if (!StaticMethodCandidateCheck.isAnonymousClass(ast)) break;
                Frame frame = new Frame(this.currentFrame);
                frame.isShouldBeChecked = false;
                this.currentFrame.addChild(frame);
                this.currentFrame = frame;
                break;
            }
            case 155: {
                Frame frame = new Frame(this.currentFrame);
                frame.isShouldBeChecked = false;
                this.currentFrame.addEnumConst(ast);
                this.currentFrame.addChild(frame);
                this.currentFrame = frame;
                break;
            }
            default: {
                Frame frame = StaticMethodCandidateCheck.createFrame(this.currentFrame, ast);
                this.currentFrame.addChild(frame);
                this.currentFrame = frame;
            }
        }
    }

    public void leaveToken(DetailAST ast) {
        if (StaticMethodCandidateCheck.isFrame(ast) || StaticMethodCandidateCheck.isAnonymousClass(ast)) {
            this.currentFrame = this.currentFrame.parent;
        }
    }

    public void finishTree(DetailAST ast) {
        this.checkFrame(this.currentFrame);
    }

    private Frame createMethodFrame(Frame parentFrame, DetailAST ast) {
        DetailAST modifiersAst = ast.findFirstToken(5);
        String methodName = ast.findFirstToken(58).getText();
        Frame frame = new Frame(parentFrame);
        if (modifiersAst.branchContains(61) && !modifiersAst.branchContains(64) && !this.skippedMethods.contains(methodName)) {
            frame.isPrivateMethod = true;
            frame.lineNo = ast.getLineNo();
            frame.frameName = StaticMethodCandidateCheck.getIdentText(ast);
        } else {
            frame.isShouldBeChecked = false;
        }
        return frame;
    }

    private static boolean isAnonymousClass(DetailAST ast) {
        int astType = ast.getType();
        return astType == 136 && ast.branchContains(72);
    }

    private static Frame createFrame(Frame parentFrame, DetailAST ast) {
        Frame frame = new Frame(parentFrame);
        int astType = ast.getType();
        if (astType == 14 || astType == 154) {
            if (astType == 14 && !ScopeUtils.isOuterMostType((DetailAST)ast) && !StaticMethodCandidateCheck.hasStaticModifier(ast)) {
                frame.isShouldBeChecked = false;
            }
            frame.frameName = StaticMethodCandidateCheck.getIdentText(ast);
            frame.isClassOrEnum = true;
        } else if (astType == 12 || astType == 11 || astType == 8 || astType == 15) {
            frame.isShouldBeChecked = false;
        }
        return frame;
    }

    private static boolean isFrame(DetailAST ast) {
        int astType = ast.getType();
        return Arrays.binarySearch(FRAME_TOKENS, astType) >= 0;
    }

    private boolean checkFrame(Frame parentFrame) {
        boolean isStaticCandidate = true;
        for (Frame frame : parentFrame.children) {
            if (!frame.isShouldBeChecked) continue;
            isStaticCandidate = this.checkFrame(frame);
            if (frame.isClassOrEnum) continue;
            boolean bl = isStaticCandidate = isStaticCandidate && !frame.hasLiteralThisOrSuper && StaticMethodCandidateCheck.isFrameExpressionsAcceptable(frame) && StaticMethodCandidateCheck.isFrameTypesAcceptable(frame);
            if (frame.isPrivateMethod) {
                if (!isStaticCandidate) continue;
                this.log(frame.lineNo, MSG_KEY, new Object[]{frame.frameName});
                continue;
            }
            if (isStaticCandidate) continue;
            break;
        }
        return isStaticCandidate;
    }

    private static String getIdentText(DetailAST field) {
        return field.findFirstToken(58).getText();
    }

    private static boolean hasStaticModifier(DetailAST ast) {
        return ast.findFirstToken(5).branchContains(64);
    }

    private static boolean isFrameExpressionsAcceptable(final Frame frame) {
        Predicate<DetailAST> predicate = new Predicate<DetailAST>(){

            public boolean apply(DetailAST ast) {
                return !StaticMethodCandidateCheck.isExprAcceptable(frame, ast);
            }
        };
        Optional result = Iterables.tryFind((Iterable)frame.expressions, (Predicate)predicate);
        return !result.isPresent();
    }

    private static boolean isFrameTypesAcceptable(final Frame frame) {
        Predicate<String> predicate = new Predicate<String>(){

            public boolean apply(String type) {
                Optional typeFrame = StaticMethodCandidateCheck.findFrameByName(frame, type);
                return typeFrame.isPresent() && !((Frame)typeFrame.get()).isShouldBeChecked || StaticMethodCandidateCheck.findTypeVariable(frame, type);
            }
        };
        Optional result = Iterables.tryFind((Iterable)frame.types, (Predicate)predicate);
        return !result.isPresent();
    }

    private static boolean isExprAcceptable(Frame frame, DetailAST expr) {
        boolean isStaticCandidate = true;
        if (expr.branchContains(58)) {
            for (DetailAST childAst = expr.getFirstChild(); childAst != null && isStaticCandidate; childAst = childAst.getNextSibling()) {
                Optional<Frame> typeFrame;
                isStaticCandidate = childAst.getType() == 27 ? StaticMethodCandidateCheck.isStaticMethod(frame, childAst) && StaticMethodCandidateCheck.isExprAcceptable(frame, childAst) : (childAst.getType() == 58 && StaticMethodCandidateCheck.isIdentShouldBeChecked(expr) ? StaticMethodCandidateCheck.isStaticFieldOrLocalVariable(frame, childAst) : (childAst.getType() == 136 ? StaticMethodCandidateCheck.isTypeFrameShouldBeChecked(typeFrame = StaticMethodCandidateCheck.findFrameByName(frame, childAst.getFirstChild().getText())) && StaticMethodCandidateCheck.isExprAcceptable(frame, childAst) : StaticMethodCandidateCheck.isExprAcceptable(frame, childAst)));
            }
        }
        return isStaticCandidate;
    }

    private static Optional<Frame> findFrameByName(Frame frame, String frameName) {
        Optional result = Optional.absent();
        Optional parentFrame = Optional.of((Object)frame.parent);
        while (parentFrame.isPresent() && !result.isPresent()) {
            for (Frame child : ((Frame)parentFrame.get()).children) {
                if (!child.isClassOrEnum || !frameName.equals(child.frameName)) continue;
                result = Optional.of((Object)child);
                break;
            }
            parentFrame = Optional.fromNullable((Object)((Frame)parentFrame.get()).parent);
        }
        return result;
    }

    private static boolean findTypeVariable(Frame frame, String type) {
        boolean result = false;
        Optional searchFrame = Optional.of((Object)frame);
        while (searchFrame.isPresent() && !result) {
            result = ((Frame)searchFrame.get()).typeVariables.contains(type);
            searchFrame = Optional.fromNullable((Object)((Frame)searchFrame.get()).parent);
        }
        return result;
    }

    private static boolean isStaticMethod(Frame frame, DetailAST methodCallAst) {
        boolean result = false;
        DetailAST firstChild = methodCallAst.getFirstChild();
        if (firstChild.getType() == 59) {
            DetailAST objCalledOn = StaticMethodCandidateCheck.getTheLeftmostIdent(methodCallAst);
            if (objCalledOn.getType() == 58) {
                Optional<DetailAST> field = StaticMethodCandidateCheck.findField(frame, objCalledOn);
                if (field.isPresent()) {
                    result = StaticMethodCandidateCheck.isAcceptableField((DetailAST)field.get());
                } else if (StaticMethodCandidateCheck.findFrameByName(frame, objCalledOn.getText()).isPresent()) {
                    result = true;
                }
            } else {
                result = true;
            }
        } else {
            result = StaticMethodCandidateCheck.findStaticMethod(frame, methodCallAst, firstChild.getText());
        }
        return result;
    }

    private static boolean isIdentShouldBeChecked(DetailAST parentAst) {
        int parentAstType = parentAst.getType();
        return parentAstType != 136 && parentAstType != 13 && parentAstType != 9;
    }

    private static boolean isStaticFieldOrLocalVariable(Frame frame, DetailAST identAst) {
        Optional<DetailAST> field;
        int parentType = identAst.getParent().getType();
        boolean result = parentType == 59 ? (identAst.getNextSibling() != null ? ((field = StaticMethodCandidateCheck.findField(frame, identAst)).isPresent() ? StaticMethodCandidateCheck.isAcceptableField((DetailAST)field.get()) : StaticMethodCandidateCheck.findFrameByName(frame, identAst.getText()).isPresent()) : true) : (parentType == 27 ? true : (field = StaticMethodCandidateCheck.findField(frame, identAst)).isPresent() && StaticMethodCandidateCheck.isAcceptableField((DetailAST)field.get()));
        return result;
    }

    private static boolean isTypeFrameShouldBeChecked(Optional<Frame> typeFrame) {
        return !typeFrame.isPresent() || ((Frame)typeFrame.get()).isShouldBeChecked;
    }

    private static DetailAST getTheLeftmostIdent(DetailAST mCall) {
        DetailAST result = mCall.getFirstChild();
        while (result.getChildCount() != 0 && result.getType() != 27) {
            result = result.getFirstChild();
        }
        return result;
    }

    private static Optional<DetailAST> findField(Frame startFrame, DetailAST identAst) {
        Optional<DetailAST> result = Optional.absent();
        Optional frame = Optional.of((Object)startFrame);
        String fieldName = identAst.getText();
        while (frame.isPresent() && !result.isPresent()) {
            Optional<DetailAST> field = ((Frame)frame.get()).findFieldInFrame(fieldName);
            if (field.isPresent()) {
                if (!StaticMethodCandidateCheck.isLocalVariable((DetailAST)field.get()) || StaticMethodCandidateCheck.checkFieldLocation((DetailAST)field.get(), identAst)) {
                    result = field;
                }
            } else {
                result = ((Frame)frame.get()).findEnumConstInFrame(fieldName);
            }
            frame = Optional.fromNullable((Object)((Frame)frame.get()).parent);
        }
        return result;
    }

    private static boolean isAcceptableField(DetailAST field) {
        boolean result = false;
        if (StaticMethodCandidateCheck.isLocalVariable(field) || field.getType() == 155 || StaticMethodCandidateCheck.hasStaticModifier(field)) {
            result = true;
        }
        return result;
    }

    private static boolean findStaticMethod(Frame startFrame, DetailAST methodCall, String checkedMethodName) {
        int argsNumber = methodCall.findFirstToken(34).getChildCount();
        Optional frame = Optional.of((Object)startFrame);
        boolean hasNonStaticMethod = false;
        boolean hasStaticMethod = false;
        while (frame.isPresent() && !hasNonStaticMethod) {
            for (DetailAST method : ((Frame)frame.get()).methods) {
                DetailAST parametersAst = method.findFirstToken(20);
                if (!checkedMethodName.equals(StaticMethodCandidateCheck.getIdentText(method)) || parametersAst.getChildCount() != argsNumber && !parametersAst.branchContains(171)) continue;
                DetailAST modifiersAst = method.findFirstToken(5);
                if (modifiersAst.branchContains(64)) {
                    hasStaticMethod = true;
                    continue;
                }
                hasNonStaticMethod = true;
                break;
            }
            frame = Optional.fromNullable((Object)((Frame)frame.get()).parent);
        }
        return hasStaticMethod && !hasNonStaticMethod;
    }

    private static boolean isLocalVariable(DetailAST ast) {
        int parentType = ast.getParent().getParent().getType();
        return parentType != 14 && parentType != 154;
    }

    private static boolean checkFieldLocation(DetailAST field, DetailAST objCalledOn) {
        boolean result = false;
        if (field.getLineNo() < objCalledOn.getLineNo() || field.getLineNo() == objCalledOn.getLineNo() && field.getColumnNo() < objCalledOn.getColumnNo()) {
            result = true;
        }
        return result;
    }

    private static class Frame {
        private String frameName;
        private final Frame parent;
        private final List<Frame> children = new LinkedList<Frame>();
        private final List<DetailAST> fields = new LinkedList<DetailAST>();
        private final List<DetailAST> methods = new LinkedList<DetailAST>();
        private final List<String> typeVariables = new LinkedList<String>();
        private final List<DetailAST> expressions = new ArrayList<DetailAST>();
        private final Set<String> types = Sets.newHashSet();
        private final Set<DetailAST> enumConstants = Sets.newHashSet();
        private boolean isClassOrEnum;
        private boolean isPrivateMethod;
        private boolean isShouldBeChecked = true;
        private boolean hasLiteralThisOrSuper;
        private int lineNo;

        Frame(Frame parent) {
            this.parent = parent;
        }

        public void addExpr(DetailAST ast) {
            this.expressions.add(ast);
        }

        public void addChild(Frame child) {
            this.children.add(child);
        }

        public void addField(DetailAST field) {
            this.fields.add(field);
        }

        public void addMethod(DetailAST method) {
            this.methods.add(method);
        }

        public void addEnumConst(DetailAST enumConst) {
            this.enumConstants.add(enumConst);
        }

        public void addTypeVariable(String typeVariable) {
            this.typeVariables.add(typeVariable);
        }

        public void addType(String type) {
            this.types.add(type);
        }

        public Optional<DetailAST> findFieldInFrame(final String name) {
            Predicate<DetailAST> predicate = new Predicate<DetailAST>(){

                public boolean apply(DetailAST field) {
                    return StaticMethodCandidateCheck.getIdentText(field).equals(name);
                }
            };
            return Iterables.tryFind(this.fields, (Predicate)predicate);
        }

        public Optional<DetailAST> findEnumConstInFrame(final String name) {
            Predicate<DetailAST> predicate = new Predicate<DetailAST>(){

                public boolean apply(DetailAST enumConstant) {
                    return StaticMethodCandidateCheck.getIdentText(enumConstant).equals(name);
                }
            };
            return Iterables.tryFind(this.enumConstants, (Predicate)predicate);
        }
    }
}

