/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceBeforeArrayInitializerCheck
extends Check {
    public static final String MSG_KEY = "whitespace.before.array.initializer";

    public int[] getDefaultTokens() {
        return new int[]{29};
    }

    public void visitToken(DetailAST ast) {
        DetailAST previousAst = WhitespaceBeforeArrayInitializerCheck.getPreviousAst(ast);
        if (!WhitespaceBeforeArrayInitializerCheck.areTokensSeparatedByWhitespace(previousAst, ast) && WhitespaceBeforeArrayInitializerCheck.isNestedArrayInitializer(ast)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean areTokensSeparatedByWhitespace(DetailAST firstAST, DetailAST secondAST) {
        int lineDistance;
        boolean isDistanceValid = true;
        int columnDistance = secondAST.getColumnNo() - firstAST.getColumnNo();
        if (columnDistance == 1 && (lineDistance = secondAST.getLineNo() - firstAST.getLineNo()) == 0) {
            isDistanceValid = false;
        }
        return isDistanceValid;
    }

    private static boolean isNestedArrayInitializer(DetailAST ast) {
        return ast.getParent().getType() != 29;
    }

    private static DetailAST getPreviousAst(DetailAST ast) {
        DetailAST previousSibling;
        DetailAST previousAst = ast.getPreviousSibling() != null ? ((previousSibling = ast.getPreviousSibling()).getChildCount() > 0 ? previousSibling.getLastChild() : previousSibling) : ast.getParent();
        return previousAst;
    }
}

