/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class UselessSuperCtorCallCheck
extends Check {
    public static final String MSG_IN_NOT_DERIVED_CLASS = "useless.super.ctor.call.in.not.derived.class";
    public static final String MSG_WITHOUT_ARGS = "useless.super.ctor.call.without.args";
    private boolean mAllowCallToNoArgsSuperCtor;
    private boolean mAllowCallToNoArgsSuperCtorIfMultiplePublicCtor;

    public void setAllowCallToNoArgsSuperCtor(boolean aAllowCallToNoArgsSuperCtor) {
        this.mAllowCallToNoArgsSuperCtor = aAllowCallToNoArgsSuperCtor;
    }

    public void setAllowCallToNoArgsSuperCtorIfMultiplePublicCtor(boolean aAllowCall) {
        this.mAllowCallToNoArgsSuperCtorIfMultiplePublicCtor = aAllowCall;
    }

    public int[] getDefaultTokens() {
        return new int[]{42};
    }

    public void visitToken(DetailAST aSuperCallNode) {
        if (UselessSuperCtorCallCheck.getSuperCallArgsCount(aSuperCallNode) == 0) {
            DetailAST classDefNode = UselessSuperCtorCallCheck.getClassDefinitionNode(aSuperCallNode);
            String className = this.getClassName(classDefNode);
            if (UselessSuperCtorCallCheck.isClassDerived(classDefNode)) {
                if (!(this.mAllowCallToNoArgsSuperCtor || this.mAllowCallToNoArgsSuperCtorIfMultiplePublicCtor && UselessSuperCtorCallCheck.getClassPublicCtorCount(classDefNode) > 1)) {
                    this.log(aSuperCallNode, MSG_WITHOUT_ARGS, new Object[]{className});
                }
            } else {
                this.log(aSuperCallNode, MSG_IN_NOT_DERIVED_CLASS, new Object[]{className});
            }
        }
    }

    private String getClassName(DetailAST aClassDefNode) {
        return aClassDefNode.findFirstToken(58).getText();
    }

    private static int getSuperCallArgsCount(DetailAST aMethodCallNode) {
        DetailAST argsListNode = aMethodCallNode.findFirstToken(34);
        return argsListNode.getChildCount();
    }

    private static DetailAST getClassDefinitionNode(DetailAST aNode) {
        DetailAST result = aNode;
        while (result.getType() != 14) {
            result = result.getParent();
        }
        return result;
    }

    private static int getClassPublicCtorCount(DetailAST aClassDefNode) {
        int publicCtorCount = 0;
        for (DetailAST classMemberNode = aClassDefNode.findFirstToken(6).getFirstChild(); classMemberNode != null; classMemberNode = classMemberNode.getNextSibling()) {
            if (classMemberNode.getType() != 8 || !UselessSuperCtorCallCheck.isCtorPublic(classMemberNode)) continue;
            ++publicCtorCount;
        }
        return publicCtorCount;
    }

    private static boolean isCtorPublic(DetailAST aCtorDefNode) {
        return aCtorDefNode.findFirstToken(5).findFirstToken(62) != null;
    }

    private static boolean isClassDerived(DetailAST aClassDefNode) {
        return aClassDefNode.findFirstToken(18) != null;
    }
}

