/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class SimpleAccessorNameNotationCheck
extends Check {
    public static final String MSG_KEY_GETTER = "incorrect.getter.name";
    public static final String MSG_KEY_SETTER = "incorrect.setter.name";
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final int EXPRESSION_BLOCK_CHILD_COUNT = 3;
    private String prefix = "";

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST methodDef) {
        String methodName = methodDef.findFirstToken(58).getText();
        if (SimpleAccessorNameNotationCheck.hasBody(methodDef) && !SimpleAccessorNameNotationCheck.isMethodAtAnonymousClass(methodDef)) {
            if (methodName.startsWith(BOOLEAN_GETTER_PREFIX)) {
                if (!this.isGetterCorrect(methodDef, methodName.substring(BOOLEAN_GETTER_PREFIX.length()))) {
                    this.log(methodDef.getLineNo(), MSG_KEY_GETTER, new Object[0]);
                }
            } else if (methodName.startsWith(SETTER_PREFIX)) {
                if (!this.isSetterCorrect(methodDef, methodName.substring(SETTER_PREFIX.length()))) {
                    this.log(methodDef.getLineNo(), MSG_KEY_SETTER, new Object[0]);
                }
            } else if (methodName.startsWith(GETTER_PREFIX) && !this.isGetterCorrect(methodDef, methodName.substring(GETTER_PREFIX.length()))) {
                this.log(methodDef.getLineNo(), MSG_KEY_GETTER, new Object[0]);
            }
        }
    }

    private boolean isSetterCorrect(DetailAST methodDef, String methodName) {
        DetailAST currentVerifiedTop;
        DetailAST methodType = methodDef.findFirstToken(13);
        boolean result = true;
        if (methodType.branchContains(49) && SimpleAccessorNameNotationCheck.containsOnlyExpression(currentVerifiedTop = methodDef.findFirstToken(7))) {
            DetailAST parameters;
            String nameOfSettingField;
            boolean containsOnlyOneAssignment;
            boolean bl = containsOnlyOneAssignment = (currentVerifiedTop = currentVerifiedTop.getFirstChild()).getChildCount() == 1 && currentVerifiedTop.getFirstChild().getType() == 80;
            if (containsOnlyOneAssignment && (nameOfSettingField = SimpleAccessorNameNotationCheck.getNameOfSettingField(currentVerifiedTop = currentVerifiedTop.getFirstChild(), parameters = methodDef.findFirstToken(20))) != null && this.verifyFieldAndMethodName(nameOfSettingField, methodName)) {
                result = false;
            }
        }
        return result;
    }

    private boolean isGetterCorrect(DetailAST methodDef, String methodName) {
        String nameOfGettingField;
        DetailAST currentVerifiedTop;
        DetailAST parameters = methodDef.findFirstToken(20);
        boolean result = true;
        if (parameters.getChildCount() == 0 && SimpleAccessorNameNotationCheck.containsOnlyReturn(currentVerifiedTop = methodDef.findFirstToken(7)) && SimpleAccessorNameNotationCheck.isCorrectReturn(currentVerifiedTop = currentVerifiedTop.getFirstChild()) && (nameOfGettingField = SimpleAccessorNameNotationCheck.getNameOfGettingField(currentVerifiedTop = currentVerifiedTop.getFirstChild())) != null && this.verifyFieldAndMethodName(nameOfGettingField, methodName)) {
            result = false;
        }
        return result;
    }

    private static boolean containsOnlyExpression(DetailAST objectBlock) {
        return objectBlock.getChildCount() == 3 && objectBlock.getFirstChild().getType() == 28 && objectBlock.findFirstToken(45) != null;
    }

    private static String getNameOfSettingField(DetailAST assign, DetailAST parameters) {
        String nameOfSettingField = null;
        DetailAST assigningFirstChild = assign.getFirstChild();
        if (assign.getChildCount() == 2 && assign.getLastChild().getType() == 58) {
            if (assigningFirstChild.getType() == 58) {
                nameOfSettingField = assigningFirstChild.getText();
                if (SimpleAccessorNameNotationCheck.checkNameOfParameters(parameters, nameOfSettingField)) {
                    nameOfSettingField = null;
                }
            } else if (assigningFirstChild.getType() == 59 && assigningFirstChild.getChildCount() == 2 && "this".equals(assigningFirstChild.getFirstChild().getText()) && assigningFirstChild.getLastChild().getType() == 58) {
                nameOfSettingField = assigningFirstChild.getLastChild().getText();
            }
        }
        return nameOfSettingField;
    }

    private boolean verifyFieldAndMethodName(String fieldName, String methodName) {
        String name = this.prefix + methodName;
        return !fieldName.equalsIgnoreCase(name);
    }

    private static boolean containsOnlyReturn(DetailAST methodBody) {
        return methodBody.getFirstChild().getType() == 88;
    }

    private static boolean isCorrectReturn(DetailAST literalReturn) {
        return literalReturn.getChildCount() == 2 && literalReturn.getFirstChild().getType() == 28 && literalReturn.getLastChild().getType() == 45;
    }

    private static String getNameOfGettingField(DetailAST expr) {
        String nameOfGettingField = null;
        if (expr.getChildCount() == 1) {
            DetailAST exprFirstChild = expr.getFirstChild();
            if (exprFirstChild.getType() == 58) {
                nameOfGettingField = exprFirstChild.getText();
            } else if (exprFirstChild.getType() == 59 && exprFirstChild.getChildCount() == 2 && exprFirstChild.getFirstChild().getType() == 78 && exprFirstChild.getLastChild().getType() == 58) {
                nameOfGettingField = exprFirstChild.getLastChild().getText();
            }
        }
        return nameOfGettingField;
    }

    private static boolean checkNameOfParameters(DetailAST paramrters, String fieldName) {
        boolean isNameOfParameter = false;
        int parametersChildCount = paramrters.getChildCount();
        DetailAST parameterDef = paramrters.findFirstToken(21);
        for (int i = 0; i < parametersChildCount && !isNameOfParameter; ++i) {
            isNameOfParameter = parameterDef.findFirstToken(58).getText().equals(fieldName);
        }
        return isNameOfParameter;
    }

    private static boolean isMethodAtAnonymousClass(DetailAST methodDef) {
        DetailAST classObjBlock = methodDef.getParent();
        return classObjBlock.getParent().getType() == 136;
    }

    private static boolean hasBody(DetailAST methodDef) {
        DetailAST body = methodDef.findFirstToken(7);
        return body != null;
    }
}

