/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.Deque;

public class ReturnNullInsteadOfBooleanCheck
extends Check {
    public static final String MSG_KEY = "return.null.Boolean";
    private final Deque<Boolean> methodStack = new ArrayDeque<Boolean>();
    private boolean exploreMethod = false;

    public int[] getDefaultTokens() {
        return new int[]{9, 88};
    }

    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    public void beginTree(DetailAST rootAST) {
        this.methodStack.clear();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 9: {
                this.methodStack.push(this.exploreMethod);
                DetailAST returnTypeAST = ast.findFirstToken(13).getFirstChild();
                this.exploreMethod = "Boolean".equals(returnTypeAST.getText());
                break;
            }
            case 88: {
                DetailAST exprToken;
                if (!this.exploreMethod || !"null".equals((exprToken = ast.findFirstToken(28).getFirstChild()).getText())) break;
                this.log(ast, MSG_KEY, new Object[0]);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 9: {
                this.exploreMethod = this.methodStack.pop();
                break;
            }
            case 88: {
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }
}

