/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MultipleStringLiteralsExtendedCheck
extends Check {
    public static final String MSG_KEY = "multiple.string.literal";
    private final Map<String, List<StringInfo>> stringMap = Maps.newHashMap();
    private final BitSet ignoreOccurrenceContext = new BitSet();
    private int allowedDuplicates = 1;
    private boolean highlightAllDuplicates = false;
    private Pattern pattern;

    public void setAllowedDuplicates(int allowedDuplicates) {
        this.allowedDuplicates = allowedDuplicates;
    }

    public MultipleStringLiteralsExtendedCheck() {
        this.setIgnoreStringsRegexp("^\"\"$");
        this.ignoreOccurrenceContext.set(159);
    }

    public void setIgnoreStringsRegexp(String ignoreStringsRegexp) {
        this.pattern = ignoreStringsRegexp != null && ignoreStringsRegexp.length() > 0 ? Pattern.compile(ignoreStringsRegexp) : null;
    }

    public final void setHighlightAllDuplicates(boolean highlightAllDuplicates) {
        this.highlightAllDuplicates = highlightAllDuplicates;
    }

    public final void setIgnoreOccurrenceContext(String[] strRep) {
        this.ignoreOccurrenceContext.clear();
        for (String s : strRep) {
            int type = TokenUtils.getTokenId((String)s);
            this.ignoreOccurrenceContext.set(type);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{139};
    }

    public void visitToken(DetailAST ast) {
        if (this.isInIgnoreOccurrenceContext(ast)) {
            return;
        }
        String currentString = ast.getText();
        if (this.pattern == null || !this.pattern.matcher(currentString).find()) {
            ArrayList hitList = this.stringMap.get(currentString);
            if (hitList == null) {
                hitList = Lists.newArrayList();
                this.stringMap.put(currentString, hitList);
            }
            int line = ast.getLineNo();
            int col = ast.getColumnNo();
            hitList.add(new StringInfo(line, col));
        }
    }

    private boolean isInIgnoreOccurrenceContext(DetailAST ast) {
        for (DetailAST token = ast.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (!this.ignoreOccurrenceContext.get(type)) continue;
            return true;
        }
        return false;
    }

    public void beginTree(DetailAST rootAST) {
        super.beginTree(rootAST);
        this.stringMap.clear();
    }

    public void finishTree(DetailAST rootAST) {
        Set<String> keys = this.stringMap.keySet();
        for (String key : keys) {
            List<StringInfo> hits = this.stringMap.get(key);
            if (hits.size() <= this.allowedDuplicates) continue;
            int hitsSize = 1;
            if (this.highlightAllDuplicates) {
                hitsSize = hits.size();
            }
            for (int index = 0; index < hitsSize; ++index) {
                StringInfo firstFinding = hits.get(index);
                int line = firstFinding.getLine();
                int col = firstFinding.getCol();
                this.log(line, col, MSG_KEY, new Object[]{key, hits.size()});
            }
        }
    }

    private static final class StringInfo {
        private final int line;
        private final int col;

        private StringInfo(int line, int col) {
            this.line = line;
            this.col = col;
        }

        private int getLine() {
            return this.line;
        }

        private int getCol() {
            return this.col;
        }
    }
}

