/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.coding.AbstractIllegalCheck;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;

public final class IllegalCatchExtendedCheck
extends AbstractIllegalCheck {
    public static final String MSG_KEY = "illegal.catch";
    private boolean allowThrow = true;
    private boolean allowRethrow = true;

    public void setAllowThrow(boolean value) {
        this.allowThrow = value;
    }

    public void setAllowRethrow(boolean value) {
        this.allowRethrow = value;
    }

    public IllegalCatchExtendedCheck() {
        super(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"});
    }

    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST detailAST) {
        DetailAST paramDef = detailAST.findFirstToken(21);
        DetailAST throwAST = this.getThrowAST(detailAST);
        DetailAST firstLvlChild = null;
        if (throwAST != null) {
            firstLvlChild = throwAST.getFirstChild();
        }
        DetailAST secondLvlChild = null;
        if (firstLvlChild != null) {
            secondLvlChild = firstLvlChild.getFirstChild();
        }
        boolean noWarning = throwAST != null && firstLvlChild != null && secondLvlChild != null && firstLvlChild.getType() == 28 && (this.allowThrow && secondLvlChild.getType() == 58 || this.allowRethrow && secondLvlChild.getType() == 136);
        DetailAST excType = paramDef.findFirstToken(13);
        FullIdent ident = CheckUtils.createFullType((DetailAST)excType);
        if (!noWarning && this.isIllegalClassName(ident.getText())) {
            this.log(detailAST, MSG_KEY, new Object[]{ident.getText()});
        }
    }

    public DetailAST getThrowAST(DetailAST parentAST) {
        DetailAST[] asts;
        for (DetailAST currentNode : asts = IllegalCatchExtendedCheck.getChilds(parentAST)) {
            DetailAST astResult;
            if (currentNode.getType() != 21 && currentNode.getNumberOfChildren() > 0 && (astResult = this.getThrowAST(currentNode)) != null) {
                return astResult;
            }
            if (currentNode.getType() == 90) {
                return currentNode;
            }
            if (currentNode.getNextSibling() == null) continue;
            currentNode = currentNode.getNextSibling();
        }
        return null;
    }

    public static DetailAST[] getChilds(DetailAST node) {
        DetailAST[] result = new DetailAST[node.getChildCount()];
        DetailAST currNode = node.getFirstChild();
        for (int i = 0; i < node.getNumberOfChildren(); ++i) {
            result[i] = currNode;
            currNode = currNode.getNextSibling();
        }
        return result;
    }
}

