/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ForbidThrowAnonymousExceptionsCheck
extends Check {
    public static final String MSG_KEY = "forbid.throw.anonymous.exception";
    private static final String DEFAULT_EXCEPTION_CLASS_NAME_REGEX = "^.*Exception";
    private Pattern pattern = Pattern.compile("^.*Exception");
    private List<String> anonymousExceptions = new ArrayList<String>();

    public void setExceptionClassNameRegex(String exceptionClassNameRegex) {
        this.pattern = Pattern.compile(exceptionClassNameRegex);
    }

    public int[] getDefaultTokens() {
        return new int[]{90, 10};
    }

    public void visitToken(DetailAST literalThrowOrVariableDefAst) {
        switch (literalThrowOrVariableDefAst.getType()) {
            case 90: {
                this.identifyThrowingAnonymousException(literalThrowOrVariableDefAst);
                break;
            }
            case 10: {
                this.lookForAnonymousExceptionDefinition(literalThrowOrVariableDefAst);
                break;
            }
            default: {
                Utils.reportInvalidToken(literalThrowOrVariableDefAst.getType());
            }
        }
    }

    private void identifyThrowingAnonymousException(DetailAST throwDefAst) {
        DetailAST throwingExceptionNameAst;
        DetailAST throwingLiteralNewAst = ForbidThrowAnonymousExceptionsCheck.getLiteralNew(throwDefAst);
        if (throwingLiteralNewAst != null && ForbidThrowAnonymousExceptionsCheck.hasObjectBlock(throwingLiteralNewAst)) {
            this.log(throwDefAst.getLineNo(), MSG_KEY, new Object[0]);
        } else if (throwingLiteralNewAst == null && (throwingExceptionNameAst = ForbidThrowAnonymousExceptionsCheck.getThrowingExceptionNameAst(throwDefAst.getFirstChild())) != null && this.anonymousExceptions.contains(throwingExceptionNameAst.getText())) {
            this.log(throwDefAst.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private void lookForAnonymousExceptionDefinition(DetailAST variableDefAst) {
        DetailAST variableNameAst;
        DetailAST variableLiteralNewAst = null;
        DetailAST variableAssignment = variableDefAst.findFirstToken(80);
        if (variableAssignment != null && variableAssignment.getFirstChild() != null) {
            variableLiteralNewAst = ForbidThrowAnonymousExceptionsCheck.getLiteralNew(variableAssignment);
        }
        if (this.isExceptionName(variableNameAst = variableDefAst.findFirstToken(13).getNextSibling())) {
            String exceptionName = variableNameAst.getText();
            if (this.anonymousExceptions.contains(exceptionName)) {
                this.anonymousExceptions.remove(exceptionName);
            }
            if (variableLiteralNewAst != null && ForbidThrowAnonymousExceptionsCheck.hasObjectBlock(variableLiteralNewAst)) {
                this.anonymousExceptions.add(exceptionName);
            }
        }
    }

    private static DetailAST getLiteralNew(DetailAST literalThrowOrVariableDefAst) {
        return literalThrowOrVariableDefAst.getFirstChild().findFirstToken(136);
    }

    private static DetailAST getThrowingExceptionNameAst(DetailAST expressionAst) {
        return expressionAst.findFirstToken(58);
    }

    private static boolean hasObjectBlock(DetailAST literalNewAst) {
        return literalNewAst.getLastChild().getType() == 6;
    }

    private boolean isExceptionName(DetailAST variableNameAst) {
        DetailAST typeAst = variableNameAst.getPreviousSibling();
        String typeName = typeAst.getFirstChild().getText();
        return this.pattern.matcher(typeName).matches();
    }
}

