/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.regex.Pattern;

public class ForbidCertainImportsCheck
extends Check {
    public static final String MSG_KEY = "forbid.certain.imports";
    private Pattern packageNamesRegexp;
    private Pattern forbiddenImportsRegexp;
    private Pattern forbiddenImportsExcludesRegexp;
    private boolean packageMatches;

    public void setPackageNameRegexp(String packageNameRegexp) {
        if (packageNameRegexp != null) {
            this.packageNamesRegexp = Pattern.compile(packageNameRegexp);
        }
    }

    public String getForbiddenImportRegexp() {
        return this.forbiddenImportsRegexp.toString();
    }

    public void setForbiddenImportsRegexp(String forbiddenImportsRegexp) {
        if (forbiddenImportsRegexp != null) {
            this.forbiddenImportsRegexp = Pattern.compile(forbiddenImportsRegexp);
        }
    }

    public String getForbiddenImportsExcludesRegexp() {
        return this.forbiddenImportsExcludesRegexp.toString();
    }

    public void setForbiddenImportsExcludesRegexp(String forbiddenImportsExcludesRegexp) {
        if (forbiddenImportsExcludesRegexp != null) {
            this.forbiddenImportsExcludesRegexp = Pattern.compile(forbiddenImportsExcludesRegexp);
        }
    }

    public int[] getDefaultTokens() {
        int[] defaultTokens = this.packageNamesRegexp == null || this.forbiddenImportsRegexp == null || this.forbiddenImportsExcludesRegexp == null ? new int[]{} : new int[]{16, 30, 136};
        return defaultTokens;
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                if (this.packageNamesRegexp == null) break;
                String packageQualifiedName = ForbidCertainImportsCheck.getText(ast);
                this.packageMatches = this.packageNamesRegexp.matcher(packageQualifiedName).matches();
                break;
            }
            case 30: {
                String importQualifiedText;
                if (!this.packageMatches || this.forbiddenImportsRegexp == null || this.forbiddenImportsExcludesRegexp == null || !this.isImportForbidden(importQualifiedText = ForbidCertainImportsCheck.getText(ast))) break;
                this.log(ast, importQualifiedText);
                break;
            }
            case 136: {
                String importQualifiedText;
                if (this.forbiddenImportsRegexp == null || this.forbiddenImportsExcludesRegexp == null || ast.findFirstToken(59) == null || !this.packageMatches || !this.isImportForbidden(importQualifiedText = ForbidCertainImportsCheck.getText(ast))) break;
                this.log(ast, importQualifiedText);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private boolean isImportForbidden(String importText) {
        return this.forbiddenImportsRegexp.matcher(importText).matches() && !this.forbiddenImportsExcludesRegexp.matcher(importText).matches();
    }

    private void log(DetailAST nodeToWarn, String importText) {
        this.log(nodeToWarn.getLineNo(), MSG_KEY, new Object[]{this.getForbiddenImportRegexp(), importText});
    }

    private static String getText(DetailAST packageDefOrImportNode) {
        String result = null;
        DetailAST identNode = packageDefOrImportNode.findFirstToken(58);
        if (identNode == null) {
            DetailAST parentDotAST = packageDefOrImportNode.findFirstToken(59);
            if (parentDotAST != null) {
                FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
                DetailAST nameAST = parentDotAST.getLastChild();
                result = dottedPathIdent.getText() + "." + nameAST.getText();
            }
        } else {
            result = identNode.getText();
        }
        return result;
    }
}

