/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Set;

public class ForbidCCommentsInMethodsCheck
extends Check {
    public static final String MSG_KEY = "forbid.c.comments.in.the.method.body";
    private Set<Integer> clangComments;

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void beginTree(DetailAST rootAST) {
        this.clangComments = this.getFileContents().getCComments().keySet();
    }

    public void visitToken(DetailAST methodNode) {
        DetailAST borders;
        if (!this.clangComments.isEmpty() && (borders = methodNode.findFirstToken(7)) != null) {
            int methodBodyBegin = borders.getLineNo();
            int methodBodyEnd = borders.getLastChild().getLineNo();
            for (int commentLineNo : this.clangComments) {
                if (commentLineNo <= methodBodyBegin || commentLineNo >= methodBodyEnd) continue;
                this.log(commentLineNo, MSG_KEY, new Object[0]);
            }
        }
    }
}

