/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.Arrays;

public class AvoidConstantAsFirstOperandInConditionCheck
extends Check {
    public static final String MSG_KEY = "avoid.constant.as.first.operand.in.condition";
    private int[] targetConstantTypes = new int[]{133, 134, 135, 137, 140, 141, 142};

    public void setTargetConstantTypes(String[] targets) {
        if (targets != null) {
            this.targetConstantTypes = new int[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                this.targetConstantTypes[i] = TokenUtils.getTokenId((String)targets[i]);
            }
            Arrays.sort(this.targetConstantTypes);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{116, 115};
    }

    public void visitToken(DetailAST detailAST) {
        if (this.isRefactoringRequired(detailAST)) {
            this.log(detailAST.getLineNo(), MSG_KEY, new Object[]{detailAST.getText()});
        }
    }

    private boolean isRefactoringRequired(DetailAST logicNode) {
        DetailAST[] children = AvoidConstantAsFirstOperandInConditionCheck.getBothChildren(logicNode);
        DetailAST firstOperand = children[0];
        DetailAST secondOperand = children[1];
        int constantType = firstOperand.getType();
        return this.isTargetConstantType(constantType) && firstOperand.branchContains(constantType) && !secondOperand.branchContains(constantType);
    }

    private static DetailAST[] getBothChildren(DetailAST logicNode) {
        DetailAST[] children = new DetailAST[2];
        int i = 0;
        for (DetailAST child = logicNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() == 76 || child.getType() == 77) continue;
            children[i++] = child;
        }
        return children;
    }

    private boolean isTargetConstantType(int targetType) {
        return Arrays.binarySearch(this.targetConstantTypes, targetType) > -1;
    }
}

